/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.media.PrismMediaFrameHandler;
import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.media.jfxmedia.events.BufferListener;
import com.sun.media.jfxmedia.events.BufferProgressEvent;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.NewFrameEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.events.PlayerTimeListener;
import com.sun.media.jfxmedia.events.VideoRendererListener;
import com.sun.media.jfxmedia.events.VideoTrackSizeListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.track.AudioTrack;
import com.sun.media.jfxmedia.track.Track;
import com.sun.media.jfxmedia.track.VideoTrack;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCMediaPlayer;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;

final class WCMediaPlayerImpl
extends WCMediaPlayer
implements PlayerStateListener,
MediaErrorListener,
VideoTrackSizeListener,
BufferListener,
PlayerTimeListener {
    private final Object lock = new Object();
    private volatile MediaPlayer player;
    private volatile CreateThread createThread;
    private volatile PrismMediaFrameHandler frameHandler;
    private final MediaFrameListener frameListener = new MediaFrameListener();
    private boolean gotFirstFrame = false;
    private int finished = 0;
    private float bufferedStart = 0.0f;
    private float bufferedEnd = 0.0f;
    private boolean buffering = false;

    WCMediaPlayerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPlayer getPlayer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.createThread != null) {
                return null;
            }
            return this.player;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPlayer(MediaPlayer p) {
        Object object = this.lock;
        synchronized (object) {
            this.player = p;
            this.installListeners();
            this.frameHandler = PrismMediaFrameHandler.getHandler(this.player);
        }
        this.finished = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(String url, String userAgent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.createThread != null) {
                this.createThread.cancel();
            }
            this.disposePlayer();
            this.createThread = new CreateThread(url, userAgent);
        }
        if (this.getPreload() != 0) {
            this.createThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelLoad() {
        Object object = this.lock;
        synchronized (object) {
            if (this.createThread != null) {
                this.createThread.cancel();
            }
        }
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            p.stop();
        }
        this.notifyNetworkStateChanged(0);
        this.notifyReadyStateChanged(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposePlayer() {
        MediaPlayer old;
        Object object = this.lock;
        synchronized (object) {
            this.removeListeners();
            old = this.player;
            this.player = null;
            if (this.frameHandler != null) {
                this.frameHandler.releaseTextures();
                this.frameHandler = null;
            }
        }
        if (old != null) {
            old.stop();
            old.dispose();
            old = null;
            if (this.frameListener != null) {
                this.frameListener.releaseVideoFrames();
            }
        }
    }

    private void installListeners() {
        if (null != this.player) {
            this.player.addMediaPlayerListener(this);
            this.player.addMediaErrorListener(this);
            this.player.addVideoTrackSizeListener(this);
            this.player.addBufferListener(this);
            this.player.getVideoRenderControl().addVideoRendererListener(this.frameListener);
        }
    }

    private void removeListeners() {
        if (null != this.player) {
            this.player.removeMediaPlayerListener(this);
            this.player.removeMediaErrorListener(this);
            this.player.removeVideoTrackSizeListener(this);
            this.player.removeBufferListener(this);
            this.player.getVideoRenderControl().removeVideoRendererListener(this.frameListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareToPlay() {
        Object object = this.lock;
        synchronized (object) {
            CreateThread t;
            if (this.player == null && (t = this.createThread) != null && t.getState() == Thread.State.NEW) {
                t.start();
            }
        }
    }

    @Override
    protected void play() {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            p.play();
            this.notifyPaused(false);
        }
    }

    @Override
    protected void pause() {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            p.pause();
            this.notifyPaused(true);
        }
    }

    @Override
    protected float getCurrentTime() {
        MediaPlayer p = this.getPlayer();
        if (p == null) {
            return 0.0f;
        }
        return this.finished == 0 ? (float)p.getPresentationTime() : (this.finished > 0 ? (float)p.getDuration() : 0.0f);
    }

    @Override
    protected void seek(float time) {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            this.finished = 0;
            if (this.getReadyState() >= 1) {
                this.notifySeeking(true, 1);
            } else {
                this.notifySeeking(true, 0);
            }
            p.seek(time);
            final float seekTime = time;
            Thread seekCompletedThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MediaPlayer p;
                    while (WCMediaPlayerImpl.this.isSeeking() && (p = WCMediaPlayerImpl.this.getPlayer()) != null) {
                        double cur = p.getPresentationTime();
                        if ((double)seekTime < 0.01 || Math.abs(cur) >= 0.01) {
                            WCMediaPlayerImpl.this.notifySeeking(false, 4);
                            break;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            seekCompletedThread.setDaemon(true);
            seekCompletedThread.start();
        }
    }

    @Override
    protected void setRate(float rate) {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            p.setRate(rate);
        }
    }

    @Override
    protected void setVolume(float volume) {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            p.setVolume(volume);
        }
    }

    @Override
    protected void setMute(boolean mute) {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            p.setMute(mute);
        }
    }

    @Override
    protected void setSize(int w, int h) {
    }

    @Override
    protected void setPreservesPitch(boolean preserve) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderCurrentFrame(WCGraphicsContext gc, int x, int y, int w, int h) {
        Object object = this.lock;
        synchronized (object) {
            this.renderImpl(gc, x, y, w, h);
        }
    }

    private void renderImpl(WCGraphicsContext gc, int x, int y, int w, int h) {
        if (verbose) {
            log.log(Level.FINER, ">>(Prism)renderImpl");
        }
        Graphics g = (Graphics)gc.getPlatformGraphics();
        Texture texture = null;
        VideoDataBuffer currentFrame = this.frameListener.getLatestFrame();
        if (null != currentFrame) {
            if (null != this.frameHandler) {
                texture = this.frameHandler.getTexture(g, currentFrame);
            }
            currentFrame.releaseFrame();
        }
        if (texture != null) {
            g.drawTexture(texture, x, y, x + w, y + h, 0.0f, 0.0f, texture.getContentWidth(), texture.getContentHeight());
            texture.unlock();
        } else {
            if (verbose) {
                log.log(Level.FINEST, "  (Prism)renderImpl, texture is null, draw black rect");
            }
            gc.fillRect(x, y, w, h, Color.BLACK);
        }
        if (verbose) {
            log.log(Level.FINER, "<<(Prism)renderImpl");
        }
    }

    @Override
    public void onReady(PlayerStateEvent pse) {
        MediaPlayer p = this.getPlayer();
        if (verbose) {
            log.log(Level.FINE, "onReady");
        }
        Media media = p.getMedia();
        boolean hasVideo = false;
        boolean hasAudio = false;
        if (media != null) {
            List<Track> tracks = media.getTracks();
            if (tracks != null) {
                if (verbose) {
                    log.log(Level.INFO, "{0} track(s) detected:", tracks.size());
                }
                for (Track track : tracks) {
                    if (track instanceof VideoTrack) {
                        hasVideo = true;
                    } else if (track instanceof AudioTrack) {
                        hasAudio = true;
                    }
                    if (!verbose) continue;
                    log.log(Level.INFO, "track: {0}", track);
                }
            } else if (verbose) {
                log.log(Level.WARNING, "onReady, tracks IS NULL");
            }
        } else if (verbose) {
            log.log(Level.WARNING, "onReady, media IS NULL");
        }
        if (verbose) {
            log.log(Level.FINE, "onReady, hasVideo:{0}, hasAudio: {1}", new Object[]{hasVideo, hasAudio});
        }
        this.notifyReady(hasVideo, hasAudio, (float)p.getDuration());
        if (!hasVideo) {
            this.notifyReadyStateChanged(4);
        } else if (this.getReadyState() < 1) {
            if (this.gotFirstFrame) {
                this.notifyReadyStateChanged(4);
            } else {
                this.notifyReadyStateChanged(1);
            }
        }
    }

    @Override
    public void onPlaying(PlayerStateEvent pse) {
        if (verbose) {
            log.log(Level.FINE, "onPlaying");
        }
        this.notifyPaused(false);
    }

    @Override
    public void onPause(PlayerStateEvent pse) {
        if (verbose) {
            log.log(Level.FINE, "onPause, time: {0}", pse.getTime());
        }
        this.notifyPaused(true);
    }

    @Override
    public void onStop(PlayerStateEvent pse) {
        if (verbose) {
            log.log(Level.FINE, "onStop");
        }
        this.notifyPaused(true);
    }

    @Override
    public void onStall(PlayerStateEvent pse) {
        if (verbose) {
            log.log(Level.FINE, "onStall");
        }
    }

    @Override
    public void onFinish(PlayerStateEvent pse) {
        MediaPlayer p = this.getPlayer();
        if (p != null) {
            int n = this.finished = p.getRate() > 0.0f ? 1 : -1;
            if (verbose) {
                log.log(Level.FINE, "onFinish, time: {0}", pse.getTime());
            }
            this.notifyFinished();
        }
    }

    @Override
    public void onHalt(PlayerStateEvent pse) {
        if (verbose) {
            log.log(Level.FINE, "onHalt");
        }
    }

    @Override
    public void onError(Object source, int errCode, String message) {
        if (verbose) {
            log.log(Level.WARNING, "onError, errCode={0}, msg={1}", new Object[]{errCode, message});
        }
        if (errCode == 4) {
            this.notifyNetworkStateChanged(4);
            this.notifyReadyStateChanged(0);
        } else {
            this.notifyNetworkStateChanged(5);
            this.notifyReadyStateChanged(0);
        }
    }

    @Override
    public void onDurationChanged(double duration) {
        if (verbose) {
            log.log(Level.FINE, "onDurationChanged, duration={0}", duration);
        }
        this.notifyDurationChanged((float)duration);
    }

    @Override
    public void onSizeChanged(int width, int height) {
        if (verbose) {
            log.log(Level.FINE, "onSizeChanged, new size = {0} x {1}", new Object[]{width, height});
        }
        this.notifySizeChanged(width, height);
    }

    private void notifyFrameArrived() {
        if (!this.gotFirstFrame) {
            if (this.getReadyState() >= 1) {
                this.notifyReadyStateChanged(4);
            }
            this.gotFirstFrame = true;
        }
        if (verbose && this.finished != 0) {
            log.log(Level.FINE, "notifyFrameArrived (after finished) time: {0}", this.getPlayer().getPresentationTime());
        }
        this.notifyNewFrame();
    }

    private void updateBufferingStatus() {
        int newNetworkState;
        int n = this.buffering ? 2 : (newNetworkState = this.bufferedStart > 0.0f ? 1 : 3);
        if (verbose) {
            log.log(Level.FINE, "updateBufferingStatus, buffered: [{0} - {1}], buffering = {2}", new Object[]{Float.valueOf(this.bufferedStart), Float.valueOf(this.bufferedEnd), this.buffering});
        }
        this.notifyNetworkStateChanged(newNetworkState);
    }

    @Override
    public void onBufferProgress(BufferProgressEvent event) {
        if (event.getDuration() < 0.0) {
            return;
        }
        double bytes2seconds = event.getDuration() / (double)event.getBufferStop();
        this.bufferedStart = (float)(bytes2seconds * (double)event.getBufferStart());
        this.bufferedEnd = (float)(bytes2seconds * (double)event.getBufferPosition());
        this.buffering = event.getBufferPosition() < event.getBufferStop();
        float[] ranges = new float[]{this.bufferedStart, this.bufferedEnd};
        int bytesLoaded = (int)(event.getBufferPosition() - event.getBufferStart());
        if (verbose) {
            log.log(Level.FINER, "onBufferProgress, bufferStart={0}, bufferStop={1}, bufferPos={2}, duration={3}; notify range [{4},[5]], bytesLoaded: {6}", new Object[]{event.getBufferStart(), event.getBufferStop(), event.getBufferPosition(), event.getDuration(), Float.valueOf(ranges[0]), Float.valueOf(ranges[1]), bytesLoaded});
        }
        this.notifyBufferChanged(ranges, bytesLoaded);
        this.updateBufferingStatus();
    }

    private final class MediaFrameListener
    implements VideoRendererListener {
        private final Object frameLock = new Object();
        private VideoDataBuffer currentFrame;
        private VideoDataBuffer nextFrame;

        private MediaFrameListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void videoFrameUpdated(NewFrameEvent nfe) {
            Object object = this.frameLock;
            synchronized (object) {
                if (null != this.nextFrame) {
                    this.nextFrame.releaseFrame();
                }
                this.nextFrame = nfe.getFrameData();
                if (null != this.nextFrame) {
                    this.nextFrame.holdFrame();
                }
            }
            WCMediaPlayerImpl.this.notifyFrameArrived();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseVideoFrames() {
            Object object = this.frameLock;
            synchronized (object) {
                if (null != this.nextFrame) {
                    this.nextFrame.releaseFrame();
                    this.nextFrame = null;
                }
                if (null != this.currentFrame) {
                    this.currentFrame.releaseFrame();
                    this.currentFrame = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoDataBuffer getLatestFrame() {
            Object object = this.frameLock;
            synchronized (object) {
                if (null != this.nextFrame) {
                    if (null != this.currentFrame) {
                        this.currentFrame.releaseFrame();
                    }
                    this.currentFrame = this.nextFrame;
                    this.nextFrame = null;
                }
                if (null != this.currentFrame) {
                    this.currentFrame.holdFrame();
                }
                return this.currentFrame;
            }
        }
    }

    private final class CreateThread
    extends Thread {
        private boolean cancelled = false;
        private final String url;
        private final String userAgent;

        private CreateThread(String url, String userAgent) {
            this.url = url;
            this.userAgent = userAgent;
            WCMediaPlayerImpl.this.gotFirstFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (verbose) {
                log.log(Level.FINE, "CreateThread: started, url={0}", this.url);
            }
            WCMediaPlayerImpl.this.notifyNetworkStateChanged(2);
            WCMediaPlayerImpl.this.notifyReadyStateChanged(0);
            MediaPlayer p = null;
            try {
                Locator locator = new Locator(new URI(this.url));
                if (this.userAgent != null) {
                    locator.setConnectionProperty("User-Agent", this.userAgent);
                }
                locator.init();
                if (verbose) {
                    log.fine("CreateThread: locator created");
                }
                p = MediaManager.getPlayer(locator);
            }
            catch (Exception ex) {
                if (verbose) {
                    log.log(Level.WARNING, "CreateThread ERROR: {0}", ex.toString());
                    ex.printStackTrace(System.out);
                }
                String errorString = "Unsupported protocol";
                String mesg = ex.toString();
                int index = mesg.indexOf(errorString);
                if (index != -1) {
                    log.warning("Unsupported protocol");
                    WCMediaPlayerImpl.this.onError(this, 4, ex.getMessage());
                } else {
                    WCMediaPlayerImpl.this.onError(this, 0, ex.getMessage());
                }
                return;
            }
            Object object = WCMediaPlayerImpl.this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    if (verbose) {
                        log.log(Level.FINE, "CreateThread: cancelled");
                    }
                    p.dispose();
                    return;
                }
                WCMediaPlayerImpl.this.createThread = null;
                WCMediaPlayerImpl.this.setPlayer(p);
            }
            if (verbose) {
                log.log(Level.FINE, "CreateThread: completed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = WCMediaPlayerImpl.this.lock;
            synchronized (object) {
                this.cancelled = true;
            }
        }
    }
}

