/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.webkit.InputMethodClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.graphics.WCPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.web.WebView;

public final class InputMethodClientImpl
implements InputMethodClient,
ExtendedInputMethodRequests {
    private static final Logger log = Logger.getLogger(InputMethodClientImpl.class.getName());
    private final WeakReference<WebView> wvRef;
    private final WebPage webPage;
    private boolean state;

    public InputMethodClientImpl(WebView wv, WebPage webPage) {
        this.wvRef = new WeakReference<WebView>(wv);
        this.webPage = webPage;
        if (webPage != null) {
            webPage.setInputMethodClient(this);
        }
    }

    @Override
    public void activateInputMethods(boolean doActivate) {
        WebView wv = (WebView)this.wvRef.get();
        if (wv != null && wv.getScene() != null) {
            wv.getScene().impl_enableInputMethodEvents(doActivate);
        }
        this.state = doActivate;
    }

    public boolean getInputMethodState() {
        return this.state;
    }

    public static WCInputMethodEvent convertToWCInputMethodEvent(InputMethodEvent ie) {
        ArrayList<Integer> underlines = new ArrayList<Integer>();
        StringBuilder composed = new StringBuilder();
        int pos = 0;
        for (InputMethodTextRun run : ie.getComposed()) {
            String rawText = run.getText();
            InputMethodHighlight imh = run.getHighlight();
            underlines.add(pos);
            underlines.add(pos + rawText.length());
            underlines.add(imh == InputMethodHighlight.SELECTED_CONVERTED || imh == InputMethodHighlight.SELECTED_RAW ? 1 : 0);
            pos += rawText.length();
            composed.append(rawText);
        }
        int size = underlines.size();
        if (size == 0) {
            underlines.add(0);
            underlines.add(pos);
            underlines.add(0);
            size = underlines.size();
        }
        int[] attributes = new int[size];
        for (int i = 0; i < size; ++i) {
            attributes[i] = (Integer)underlines.get(i);
        }
        return new WCInputMethodEvent(ie.getCommitted(), composed.toString(), attributes, ie.getCaretPosition());
    }

    private <T> T callOnEventThread(Callable<T> callable) {
        FutureTask<T> f = new FutureTask<T>(callable);
        Invoker.getInvoker().invokeOnEventThread(f);
        T result = null;
        try {
            result = f.get();
        }
        catch (ExecutionException ex) {
            log.severe("InputMethodClientImpl " + ex);
        }
        catch (InterruptedException ex) {
            log.severe("InputMethodClientImpl InterruptedException" + ex);
        }
        return result;
    }

    @Override
    public Point2D getTextLocation(int offset) {
        Point2D result = this.callOnEventThread(() -> {
            int[] loc = this.webPage.getClientTextLocation(offset);
            WCPoint point = this.webPage.getPageClient().windowToScreen(new WCPoint(loc[0], loc[1] + loc[3]));
            return new Point2D(point.getIntX(), point.getIntY());
        });
        return result;
    }

    @Override
    public int getLocationOffset(int x, int y) {
        Integer result = this.callOnEventThread(() -> {
            WCPoint point = this.webPage.getPageClient().windowToScreen(new WCPoint(0.0f, 0.0f));
            return this.webPage.getClientLocationOffset(x - point.getIntX(), y - point.getIntY());
        });
        return result != null ? result : 0;
    }

    @Override
    public void cancelLatestCommittedText() {
    }

    @Override
    public String getSelectedText() {
        String result = this.callOnEventThread(() -> this.webPage.getClientSelectedText());
        return result != null ? result : "";
    }

    @Override
    public int getInsertPositionOffset() {
        Integer result = this.callOnEventThread(() -> this.webPage.getClientInsertPositionOffset());
        return result != null ? result : 0;
    }

    @Override
    public String getCommittedText(int begin, int end) {
        String result = this.callOnEventThread(() -> {
            try {
                return this.webPage.getClientCommittedText().substring(begin, end);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return result != null ? result : "";
    }

    @Override
    public int getCommittedTextLength() {
        Integer result = this.callOnEventThread(() -> this.webPage.getClientCommittedTextLength());
        return result != null ? result : 0;
    }
}

