/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ImageTools {
    public static final int PROGRESS_INTERVAL = 5;

    public static int readFully(InputStream stream, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int requestedLength = len;
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (len > 0) {
            int nbytes = stream.read(b, off, len);
            if (nbytes == -1) {
                throw new EOFException();
            }
            off += nbytes;
            len -= nbytes;
        }
        return requestedLength;
    }

    public static int readFully(InputStream stream, byte[] b) throws IOException {
        return ImageTools.readFully(stream, b, 0, b.length);
    }

    public static void skipFully(InputStream stream, long n) throws IOException {
        while (n > 0L) {
            long skipped = stream.skip(n);
            if (skipped <= 0L) {
                if (stream.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            n -= skipped;
        }
    }

    public static ImageStorage.ImageType getConvertedType(ImageStorage.ImageType type) {
        ImageStorage.ImageType retType = type;
        switch (type) {
            case GRAY: {
                retType = ImageStorage.ImageType.GRAY;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: 
            case RGBA: {
                retType = ImageStorage.ImageType.RGBA_PRE;
                break;
            }
            case PALETTE: 
            case RGB: {
                retType = ImageStorage.ImageType.RGB;
                break;
            }
            case RGBA_PRE: {
                retType = ImageStorage.ImageType.RGBA_PRE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ImageType " + (Object)((Object)type));
            }
        }
        return retType;
    }

    public static byte[] createImageArray(ImageStorage.ImageType type, int width, int height) {
        int numBands = 0;
        switch (type) {
            case GRAY: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE: {
                numBands = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                numBands = 2;
                break;
            }
            case RGB: {
                numBands = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                numBands = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ImageType " + (Object)((Object)type));
            }
        }
        return new byte[width * height * numBands];
    }

    public static ImageFrame convertImageFrame(ImageFrame frame) {
        ImageFrame retFrame;
        ImageStorage.ImageType type = frame.getImageType();
        ImageStorage.ImageType convertedType = ImageTools.getConvertedType(type);
        if (convertedType == type) {
            retFrame = frame;
        } else {
            byte[] inArray = null;
            Buffer buf = frame.getImageData();
            if (!(buf instanceof ByteBuffer)) {
                throw new IllegalArgumentException("!(frame.getImageData() instanceof ByteBuffer)");
            }
            ByteBuffer bbuf = (ByteBuffer)buf;
            if (bbuf.hasArray()) {
                inArray = bbuf.array();
            } else {
                inArray = new byte[bbuf.capacity()];
                bbuf.get(inArray);
            }
            int width = frame.getWidth();
            int height = frame.getHeight();
            int inStride = frame.getStride();
            byte[] outArray = ImageTools.createImageArray(convertedType, width, height);
            ByteBuffer newBuf = ByteBuffer.wrap(outArray);
            int outStride = outArray.length / height;
            byte[][] palette = frame.getPalette();
            ImageMetadata metadata = frame.getMetadata();
            int transparentIndex = metadata.transparentIndex != null ? metadata.transparentIndex : 0;
            ImageTools.convert(width, height, type, inArray, 0, inStride, outArray, 0, outStride, palette, transparentIndex, false);
            ImageMetadata imd = new ImageMetadata(metadata.gamma, metadata.blackIsZero, null, metadata.backgroundColor, null, metadata.delayTime, metadata.loopCount, metadata.imageWidth, metadata.imageHeight, metadata.imageLeftPosition, metadata.imageTopPosition, metadata.disposalMethod);
            retFrame = new ImageFrame(convertedType, newBuf, width, height, outStride, null, imd);
        }
        return retFrame;
    }

    public static byte[] convert(int width, int height, ImageStorage.ImageType inputType, byte[] input, int inputOffset, int inRowStride, byte[] output, int outputOffset, int outRowStride, byte[][] palette, int transparentIndex, boolean skipTransparent) {
        if (inputType == ImageStorage.ImageType.GRAY || inputType == ImageStorage.ImageType.RGB || inputType == ImageStorage.ImageType.RGBA_PRE) {
            if (input != output) {
                int bytesPerRow = width;
                if (inputType == ImageStorage.ImageType.RGB) {
                    bytesPerRow *= 3;
                } else if (inputType == ImageStorage.ImageType.RGBA_PRE) {
                    bytesPerRow *= 4;
                }
                if (height == 1) {
                    System.arraycopy(input, inputOffset, output, outputOffset, bytesPerRow);
                } else {
                    int inRowOffset = inputOffset;
                    int outRowOffset = outputOffset;
                    for (int row = 0; row < height; ++row) {
                        System.arraycopy(input, inRowOffset, output, outRowOffset, bytesPerRow);
                        inRowOffset += inRowStride;
                        outRowOffset += outRowStride;
                    }
                }
            }
        } else if (inputType == ImageStorage.ImageType.GRAY_ALPHA || inputType == ImageStorage.ImageType.GRAY_ALPHA_PRE) {
            int inOffset = inputOffset;
            int outOffset = outputOffset;
            if (inputType == ImageStorage.ImageType.GRAY_ALPHA) {
                for (int y = 0; y < height; ++y) {
                    int inOff = inOffset;
                    int outOff = outOffset;
                    for (int x = 0; x < width; ++x) {
                        byte gray = input[inOff++];
                        int alpha = input[inOff++] & 0xFF;
                        float f = (float)alpha / 255.0f;
                        gray = (byte)(f * (float)(gray & 0xFF));
                        output[outOff++] = gray;
                        output[outOff++] = gray;
                        output[outOff++] = gray;
                        output[outOff++] = (byte)alpha;
                    }
                    inOffset += inRowStride;
                    outOffset += outRowStride;
                }
            } else {
                for (int y = 0; y < height; ++y) {
                    int inOff = inOffset;
                    int outOff = outOffset;
                    for (int x = 0; x < width; ++x) {
                        byte gray = input[inOff++];
                        output[outOff++] = gray;
                        output[outOff++] = gray;
                        output[outOff++] = gray;
                        output[outOff++] = input[inOff++];
                    }
                    inOffset += inRowStride;
                    outOffset += outRowStride;
                }
            }
        } else if (inputType == ImageStorage.ImageType.PALETTE) {
            int inOffset = inputOffset;
            int outOffset = outputOffset;
            byte[] red = palette[0];
            byte[] green = palette[1];
            byte[] blue = palette[2];
            int inOff = inOffset;
            int outOff = outOffset;
            for (int x = 0; x < width; ++x) {
                int index = input[inOff++] & 0xFF;
                output[outOff++] = red[index];
                output[outOff++] = green[index];
                output[outOff++] = blue[index];
                outOffset += outRowStride;
            }
        } else if (inputType == ImageStorage.ImageType.PALETTE_ALPHA) {
            int inOffset = inputOffset;
            int outOffset = outputOffset;
            byte[] red = palette[0];
            byte[] green = palette[1];
            byte[] blue = palette[2];
            byte[] alpha = palette[3];
            int inOff = inOffset;
            int outOff = outOffset;
            for (int x = 0; x < width; ++x) {
                int index = input[inOff++] & 0xFF;
                byte r = red[index];
                byte g = green[index];
                byte b = blue[index];
                int a = alpha[index] & 0xFF;
                float f = (float)a / 255.0f;
                output[outOff++] = (byte)(f * (float)(r & 0xFF));
                output[outOff++] = (byte)(f * (float)(g & 0xFF));
                output[outOff++] = (byte)(f * (float)(b & 0xFF));
                output[outOff++] = (byte)a;
            }
            inOffset += inRowStride;
            outOffset += outRowStride;
        } else if (inputType == ImageStorage.ImageType.PALETTE_ALPHA_PRE) {
            int inOffset = inputOffset;
            int outOffset = outputOffset;
            byte[] red = palette[0];
            byte[] green = palette[1];
            byte[] blue = palette[2];
            byte[] alpha = palette[3];
            for (int y = 0; y < height; ++y) {
                int inOff = inOffset;
                int outOff = outOffset;
                for (int x = 0; x < width; ++x) {
                    int index = input[inOff++] & 0xFF;
                    output[outOff++] = red[index];
                    output[outOff++] = green[index];
                    output[outOff++] = blue[index];
                    output[outOff++] = alpha[index];
                }
                inOffset += inRowStride;
                outOffset += outRowStride;
            }
        } else if (inputType == ImageStorage.ImageType.PALETTE_TRANS) {
            int inOffset = inputOffset;
            int outOffset = outputOffset;
            for (int y = 0; y < height; ++y) {
                int inOff = inOffset;
                int outOff = outOffset;
                byte[] red = palette[0];
                byte[] green = palette[1];
                byte[] blue = palette[2];
                for (int x = 0; x < width; ++x) {
                    int index;
                    if ((index = input[inOff++] & 0xFF) == transparentIndex) {
                        if (skipTransparent) {
                            outOff += 4;
                            continue;
                        }
                        output[outOff++] = 0;
                        output[outOff++] = 0;
                        output[outOff++] = 0;
                        output[outOff++] = 0;
                        continue;
                    }
                    output[outOff++] = red[index];
                    output[outOff++] = green[index];
                    output[outOff++] = blue[index];
                    output[outOff++] = -1;
                }
                inOffset += inRowStride;
                outOffset += outRowStride;
            }
        } else if (inputType == ImageStorage.ImageType.RGBA) {
            int inOffset = inputOffset;
            int outOffset = outputOffset;
            for (int y = 0; y < height; ++y) {
                int inOff = inOffset;
                int outOff = outOffset;
                for (int x = 0; x < width; ++x) {
                    byte red = input[inOff++];
                    byte green = input[inOff++];
                    byte blue = input[inOff++];
                    int alpha = input[inOff++] & 0xFF;
                    float f = (float)alpha / 255.0f;
                    output[outOff++] = (byte)(f * (float)(red & 0xFF));
                    output[outOff++] = (byte)(f * (float)(green & 0xFF));
                    output[outOff++] = (byte)(f * (float)(blue & 0xFF));
                    output[outOff++] = (byte)alpha;
                }
                inOffset += inRowStride;
                outOffset += outRowStride;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported ImageType " + (Object)((Object)inputType));
        }
        return output;
    }

    public static String getScaledImageName(String path) {
        StringBuilder result = new StringBuilder();
        int slash = path.lastIndexOf(47);
        String name = slash < 0 ? path : path.substring(slash + 1);
        int dot = name.lastIndexOf(".");
        if (dot < 0) {
            dot = name.length();
        }
        if (slash >= 0) {
            result.append(path.substring(0, slash + 1));
        }
        result.append(name.substring(0, dot));
        result.append("@2x");
        result.append(name.substring(dot));
        return result.toString();
    }

    public static InputStream createInputStream(String input) throws IOException {
        InputStream stream = null;
        try {
            File file = new File(input);
            if (file.exists()) {
                stream = new FileInputStream(file);
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        if (stream == null) {
            URL url = new URL(input);
            stream = url.openStream();
        }
        return stream;
    }

    private static void computeUpdatedPixels(int sourceOffset, int sourceExtent, int destinationOffset, int dstMin, int dstMax, int sourceSubsampling, int passStart, int passExtent, int passPeriod, int[] vals, int offset) {
        boolean gotPixel = false;
        int firstDst = -1;
        int secondDst = -1;
        int lastDst = -1;
        for (int i = 0; i < passExtent; ++i) {
            int src = passStart + i * passPeriod;
            if (src < sourceOffset || (src - sourceOffset) % sourceSubsampling != 0) continue;
            if (src >= sourceOffset + sourceExtent) break;
            int dst = destinationOffset + (src - sourceOffset) / sourceSubsampling;
            if (dst < dstMin) continue;
            if (dst > dstMax) break;
            if (!gotPixel) {
                firstDst = dst;
                gotPixel = true;
            } else if (secondDst == -1) {
                secondDst = dst;
            }
            lastDst = dst;
        }
        vals[offset] = firstDst;
        vals[offset + 2] = !gotPixel ? 0 : lastDst - firstDst + 1;
        vals[offset + 4] = Math.max(secondDst - firstDst, 1);
    }

    public static int[] computeUpdatedPixels(Rectangle sourceRegion, Point2D destinationOffset, int dstMinX, int dstMinY, int dstMaxX, int dstMaxY, int sourceXSubsampling, int sourceYSubsampling, int passXStart, int passYStart, int passWidth, int passHeight, int passPeriodX, int passPeriodY) {
        int[] vals = new int[6];
        ImageTools.computeUpdatedPixels(sourceRegion.x, sourceRegion.width, (int)(destinationOffset.x + 0.5f), dstMinX, dstMaxX, sourceXSubsampling, passXStart, passWidth, passPeriodX, vals, 0);
        ImageTools.computeUpdatedPixels(sourceRegion.y, sourceRegion.height, (int)(destinationOffset.y + 0.5f), dstMinY, dstMaxY, sourceYSubsampling, passYStart, passHeight, passPeriodY, vals, 1);
        return vals;
    }

    public static int[] computeDimensions(int sourceWidth, int sourceHeight, int maxWidth, int maxHeight, boolean preserveAspectRatio) {
        int finalHeight;
        int finalWidth = maxWidth < 0 ? 0 : maxWidth;
        int n = finalHeight = maxHeight < 0 ? 0 : maxHeight;
        if (finalWidth == 0 && finalHeight == 0) {
            finalWidth = sourceWidth;
            finalHeight = sourceHeight;
        } else if (finalWidth != sourceWidth || finalHeight != sourceHeight) {
            if (preserveAspectRatio) {
                if (finalWidth == 0) {
                    finalWidth = (int)((float)sourceWidth * (float)finalHeight / (float)sourceHeight);
                } else if (finalHeight == 0) {
                    finalHeight = (int)((float)sourceHeight * (float)finalWidth / (float)sourceWidth);
                } else {
                    float scale = Math.min((float)finalWidth / (float)sourceWidth, (float)finalHeight / (float)sourceHeight);
                    finalWidth = (int)((float)sourceWidth * scale);
                    finalHeight = (int)((float)sourceHeight * scale);
                }
            } else {
                if (finalHeight == 0) {
                    finalHeight = sourceHeight;
                }
                if (finalWidth == 0) {
                    finalWidth = sourceWidth;
                }
            }
            if (finalWidth <= 0) {
                finalWidth = 1;
            }
            if (finalHeight <= 0) {
                finalHeight = 1;
            }
        }
        return new int[]{finalWidth, finalHeight};
    }

    public static ImageFrame scaleImageFrame(ImageFrame src, int destWidth, int destHeight, boolean isSmooth) {
        int numBands = ImageStorage.getNumBands(src.getImageType());
        ByteBuffer dst = ImageTools.scaleImage((ByteBuffer)src.getImageData(), src.getWidth(), src.getHeight(), numBands, destWidth, destHeight, isSmooth);
        return new ImageFrame(src.getImageType(), dst, destWidth, destHeight, destWidth * numBands, null, src.getMetadata());
    }

    public static ByteBuffer scaleImage(ByteBuffer src, int sourceWidth, int sourceHeight, int numBands, int destWidth, int destHeight, boolean isSmooth) {
        PushbroomScaler scaler = ScalerFactory.createScaler(sourceWidth, sourceHeight, numBands, destWidth, destHeight, isSmooth);
        int stride = sourceWidth * numBands;
        if (src.hasArray()) {
            byte[] image = src.array();
            for (int y = 0; y != sourceHeight; ++y) {
                scaler.putSourceScanline(image, y * stride);
            }
        } else {
            byte[] scanline = new byte[stride];
            for (int y = 0; y != sourceHeight; ++y) {
                src.get(scanline);
                scaler.putSourceScanline(scanline, 0);
            }
        }
        return scaler.getDestination();
    }
}

